% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_cancel_bundle_task}
\alias{ec2_cancel_bundle_task}
\title{Cancel Bundle Task}
\usage{
ec2_cancel_bundle_task(
  BundleId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{BundleId}{String. The ID of the bundle task.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Cancels a bundling operation for an instance
store-backed Windows instance.
}
\section{BundleId}{

The ID of
the bundle task.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

