% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_seq_into_org.R
\name{convert_seq_into_org}
\alias{convert_seq_into_org}
\title{Converts a genome instruction sequence into a digital organism file}
\usage{
convert_seq_into_org(
  genome_seq,
  save = FALSE,
  file_name = NULL,
  save_path = getwd(),
  format = "org",
  silent = FALSE
)
}
\arguments{
\item{genome_seq}{String of letters.}

\item{save}{Logical value (TRUE/FALSE) indicating whether the output should
or should not be saved to a file ("FALSE" by default).}

\item{file_name}{String of characters representing the name of the file
without any extension ("organism.org" by default).}

\item{save_path}{String of characters representing the name of the folder
where the digital organism file will be saved.}

\item{format}{String of characters representing the format of the file
("org" by default).}

\item{silent}{Logical value (TRUE/FALSE) to show/hide messages
("FALSE" by default).}
}
\value{
Data frame. Column names: "genome".
}
\description{
Converts a genome instruction sequence into a digital organism
file.
}
\examples{

# Create triplestore object
triplestore <- triplestore_access$new()

# Set access options
triplestore$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

sequence <- get_genome_seq_from_genome_id(genome_id = 1, triplestore)$genome_seq[[1]]

convert_seq_into_org(genome_seq = sequence)

}
