% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_access.R
\docType{data}
\name{triplestore}
\alias{triplestore}
\title{Set options to access the database}
\format{
An object of class \code{triplestore_access} (inherits from \code{R6}) of length 7.
}
\usage{
triplestore
}
\description{
Set options to access a specific triple-store implemented in
GraphDB.
}
\examples{

# Set access options to graphddb
triplestore$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_tests"
)

# Show current access options
triplestore$access_options()

# Querying data with SPARQL
triplestore$submit_query('PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
                         PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>
                         select ?tandem_id where { 
                           ?digital_tandem_repeat rdfs:label "digital tandem repeat"@en .
                           ?tandem_id a ?digital_tandem_repeat .
                         } limit 10')

# Show ontology info
triplestore$ontology()

}
\keyword{datasets}
