% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI}
\alias{AUTO_VI}
\alias{auto_vi}
\title{AUTO_VI class environment}
\usage{
auto_vi(
  fitted_model,
  keras_model = NULL,
  data = NULL,
  node_index = 1L,
  env = new.env(parent = parent.frame()),
  init_call = sys.call()
)
}
\arguments{
\item{fitted_model}{Model. A model object, e.g. \code{lm}.}

\item{keras_model}{Keras model. A trained computer vision model.}

\item{data}{Data frame. The data used to fit the model.}

\item{node_index}{Integer. An index indicating which node of the output layer
contains the visual signal strength. This is particularly useful
when the keras model has more than one output nodes.}

\item{env}{Environment. The instance environment.}

\item{init_call}{Call. Contents of the \code{..init_call...} It is recommended to leave it
as default.}
}
\value{
An instance environment.
}
\description{
This is the class of auto visual inference,
inherited from \link[bandicoot:BASE]{bandicoot::BASE}. It is an environment
with S3 class \code{bandicoot_oop}.
}
\section{Functions}{
\itemize{
\item \code{auto_vi()}: Class constructor, same as \code{AUTO_VI$instantiate()}.

}}
\section{Class information}{
\subsection{Parent classes}{
\itemize{
\item Direct:
\itemize{
\item \link[bandicoot:BASE]{bandicoot::BASE}
}
}
}

\subsection{New attributes}{
\itemize{
\item C:
\itemize{
\item \link{AUTO_VI$check_result}
}
}
}

\subsection{New methods}{
\itemize{
\item A:
\itemize{
\item \code{\link[=AUTO_VI$auxiliary]{AUTO_VI$auxiliary()}}
}
\item B:
\itemize{
\item \code{\link[=AUTO_VI$boot_vss]{AUTO_VI$boot_vss()}}
}
\item C:
\itemize{
\item \code{\link[=AUTO_VI$check]{AUTO_VI$check()}}
}
\item F:
\itemize{
\item \code{\link[=AUTO_VI$feature_pca]{AUTO_VI$feature_pca()}}
\item \code{\link[=AUTO_VI$feature_pca_plot]{AUTO_VI$feature_pca_plot()}}
}
\item G:
\itemize{
\item \code{\link[=AUTO_VI$get_data]{AUTO_VI$get_data()}}
\item \code{\link[=AUTO_VI$get_fitted_and_resid]{AUTO_VI$get_fitted_and_resid()}}
}
\item I:
\itemize{
\item \code{\link[=AUTO_VI$..init..]{AUTO_VI$..init..()}}
}
\item L:
\itemize{
\item \code{\link[=AUTO_VI$lineup_check]{AUTO_VI$lineup_check()}}
\item \code{\link[=AUTO_VI$likelihood_ratio]{AUTO_VI$likelihood_ratio()}}
}
\item N:
\itemize{
\item \code{\link[=AUTO_VI$null_method]{AUTO_VI$null_method()}}
\item \code{\link[=AUTO_VI$null_vss]{AUTO_VI$null_vss()}}
}
\item P:
\itemize{
\item \code{\link[=AUTO_VI$p_value]{AUTO_VI$p_value()}}
\item \code{\link[=AUTO_VI$plot_resid]{AUTO_VI$plot_resid()}}
}
\item R:
\itemize{
\item \code{\link[=AUTO_VI$rotate_resid]{AUTO_VI$rotate_resid()}}
}
\item S:
\itemize{
\item \code{\link[=AUTO_VI$select_feature]{AUTO_VI$select_feature()}}
\item \code{\link[=AUTO_VI$..str..]{AUTO_VI$..str..()}}
\item \code{\link[=AUTO_VI$summary_density_plot]{AUTO_VI$summary_density_plot()}}
\item \code{\link[=AUTO_VI$summary_plot]{AUTO_VI$summary_plot()}}
\item \code{\link[=AUTO_VI$summary_rank_plot]{AUTO_VI$summary_rank_plot()}}
}
\item V:
\itemize{
\item \code{\link[=AUTO_VI$vss]{AUTO_VI$vss()}}
}
}
}
}

