% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyModels.R
\name{tidy_glm}
\alias{tidy_glm}
\title{tidy glm}
\usage{
tidy_glm(data, formula)
}
\arguments{
\item{data}{dataframe}

\item{formula}{formula}
}
\value{
glm model
}
\description{
Runs either a linear regression, logistic regression, or multinomial classification. The model is
automatically determined based off the nature of the target variable.
}
\examples{

# linear regression
iris \%>\%
tidy_glm(
tidy_formula(., target = Petal.Width)) -> glm1

glm1

glm1 \%>\%
visualize_model()

# multinomial classification

tidy_formula(iris, target = Species) -> species_form

iris \%>\%
tidy_glm(species_form) -> glm2


glm2 \%>\%
visualize_model()

#  logistic regression
iris \%>\%
dplyr::filter(Species != "setosa") \%>\%
tidy_glm(species_form) -> glm3

suppressWarnings({
glm3 \%>\%
visualize_model()})
}
