% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_strength_from_test}
\alias{get_strength_from_test}
\title{Returns the strength of a test.
This is a different kind of value for each test. It will also return what the value is.
These are the different types of data it can return:}
\usage{
get_strength_from_test(test_object)
}
\arguments{
\item{test_object}{An object containing a statistical test result and metadata,
expected to have methods `getResult()` and `getTest()`.}
}
\value{
A named numeric value indicating the strength of the result.
The type and meaning depend on the test used:
\describe{
  \item{coefficient}{Effect size and direction of predictors in regression}
  \item{r}{Correlation strength and direction}
  \item{mean difference}{Difference in group means}
  \item{statistic}{Test statistic measuring group difference or association}
  \item{F statistic}{Ratio of variances across groups}
  \item{proportion}{Estimated success rate in the sample}
  \item{non-existent}{No interpretable strength measure available}
}
}
\description{
This function takes a `test_object` that contains the result of a statistical test
and returns the main coefficient, estimate, or test statistic as a numeric value.
It supports various tests such as t-tests, ANOVAs, regressions, and correlations.
}
\keyword{internal}
