% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppoints.R
\name{ppoints}
\alias{ppoints}
\title{Projected points function}
\usage{
ppoints(x, y = NULL, type = "p", proj, ...)
}
\arguments{
\item{x}{coordinate vectors of points to plot.}

\item{y}{coordinate vectors of points to plot.}

\item{type}{character indicating the type of plotting; actually any of
    the \code{type}s as in \code{\link{plot.default}}.}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{...}{Further graphical parameters passed to the 
\code{\link[graphics]{points}} function.}
}
\description{
\code{ppoints} draws a sequence of points for projected 
coordinates.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used for 
projection.
}
\examples{
data(narccap)
# plot image using bonne projection (w/o grid lines)
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 40, paxes.args = list(grid = FALSE))
# get U.S. cities with population of about 40k or more
data(us.cities, package = "maps")
# add cities to existing plot
ppoints(us.cities$long, us.cities$lat, proj = "bonne")
}
\seealso{
\code{\link[graphics]{points}}, 
  \code{\link[mapproj]{mapproject}}, 
  \code{\link[autoimage]{pimage}}
}
