% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_kernel.R
\name{K2}
\alias{K2}
\title{Compute tree similarity}
\usage{
K2(t1, t2, verbose = FALSE)
}
\arguments{
\item{t1}{A TreeHarp object.}

\item{t2}{A TreeHarp object.}

\item{verbose}{A logical value, indicating if the output should be verbose.}
}
\value{
An integer, that counts the number of sub-trees in common between 
the two trees. Please see the reference papers for more information.
}
\description{
Compute tree similarity
}
\details{
As far as possible, this function tries to do things recursively.
It sets up a n x m matrix and fills up as much as it can. Then it uses 
recursive relationships to fill in the rest. When it cannot, it uses
\code{\link{generate_all_subtrees}} to generate and count common subtrees.
}
\examples{
tree1 <- TreeHarp(quote(x <- 1), TRUE)
tree2 <- TreeHarp(quote(y <- 1), TRUE)
K2(tree1, tree2, TRUE)

}
\references{
\enumerate{
\item 
\emph{Convolution kernels for natural language}, M Collins and N Duffy, 
\emph{Advances in neural information processing systems}, 2002.

\item 
\emph{Convolution kernels on discrete structures}, D Haussler, 
\emph{Technical report, Department of Computer Science, UC Santa Cruz}, 1999.
}
}
