% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{carve_mst}
\alias{carve_mst}
\title{Carve a Minimal Spanning Tree Out}
\usage{
carve_mst(th, node_names)
}
\arguments{
\item{th}{An object of class TreeHarp.}

\item{node_names}{A character vector of node names. Nodes outside this set 
will not be returned in the tree. It must include the root node name.}
}
\value{
An object of class TreeHarp.
}
\description{
Given node names, this function retrieves the smallest tree containing at most 
those nodes.
}
\details{
The function starts from each node specified and works it's way up
to the root. If a branch contains nodes outside the list, it is shortened.

In the end, the tree that is returned will try to contain all the named nodes,
but if that's not possible some will dropped to ensure a tree is returned, 
not a disconnected graph.
}
\examples{
ex1 <- quote(x <- f(y, g(5)))
th1 <- TreeHarp(ex1, TRUE)
carve_mst(th1, c("<-", "x", "f", "5")) ## note: 5 is dropped.
carve_mst(th1, c("<-", "x", "f", "y")) 
carve_mst(th1, c("<-", "f", "g")) 

}
