% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{aur_get}
\alias{aur_get}
\alias{aur_build_request}
\title{Fetch AURIN dataset.}
\usage{
aur_get(open_api_id, crs = "EPSG:4326", params = NULL)

aur_build_request(
  open_api_id,
  crs = "EPSG:4326",
  params = NULL,
  outputFormat = "application/json"
)
}
\arguments{
\item{open_api_id}{Character. You can find the layer names for AURIN’s datasets
by browsing the \href{https://aurin.org.au/resources/aurin-apis/aurin-open-api-and-r/}{Data Catalogue}.
The layer name is found in the ‘AURIN Open API ID’ field in a dataset’s metadata.}

\item{crs}{default as "EPSG:4326". The Coordinate Reference System you wish to use}

\item{params}{a named list that will be used when constructing the WFS request.}

\item{outputFormat}{default as "application/json",
see https://docs.geoserver.org/latest/en/user/services/wfs/outputformats.html
for other available options.}
}
\value{
an \code{sf::sf} object.
}
\description{
Query data using \href{https://docs.geoserver.org/latest/en/user/services/wfs/reference.html}{WFS getFeature}.
}
\note{
\code{aur_build_request()} returns a URL.
}
\examples{
# follow the example in https://aurin.org.au/resources/aurin-apis/aurin-open-api-and-r/
\dontrun{
aur_get("aurin:datasource-UQ_ERG-UoM_AURIN_DB_public_toilets")
}
}
