% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avro_typemap.R
\name{avro_typemap}
\alias{avro_typemap}
\title{avro_typemap}
\usage{
avro_typemap(...)
}
\arguments{
\item{...}{key-value pairs of Avro type schemas}
}
\value{
a function that yields Avro type schemas or just their names
}
\description{
Convenience function for ensuring that Avro type schemas are declared exactly 
once. It returns a function that yields a full type declaration the first 
time it is invoked and just a name on subsequent times.
}
\examples{
tm <- avro_typemap(
    MyType1 = avro_record(list(one = avro_int, two = avro_double, three = avro_string)),
    MyType2 = avro_array(avro_double)
)
tm("MyType1")           # produces the whole declaration
tm("MyType1")           # produces just "MyType1"
tm("MyType2")           # produces the whole declaration
tm("MyType2")           # produces the declaration again because this is not a named type
}
