% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_ebd}
\alias{read_ebd}
\alias{read_ebd.character}
\alias{read_ebd.auk_ebd}
\alias{read_sampling}
\alias{read_sampling.character}
\alias{read_sampling.auk_ebd}
\alias{read_sampling.auk_sampling}
\title{Read an EBD file}
\usage{
read_ebd(x, sep = "\\t", unique = TRUE, rollup = TRUE)

\method{read_ebd}{character}(x, sep = "\\t", unique = TRUE, rollup = TRUE)

\method{read_ebd}{auk_ebd}(x, sep = "\\t", unique = TRUE, rollup = TRUE)

read_sampling(x, sep = "\\t", unique = TRUE)

\method{read_sampling}{character}(x, sep = "\\t", unique = TRUE)

\method{read_sampling}{auk_ebd}(x, sep = "\\t", unique = TRUE)

\method{read_sampling}{auk_sampling}(x, sep = "\\t", unique = TRUE)
}
\arguments{
\item{x}{filename or \code{auk_ebd} object with associated output
files as created by \code{\link[=auk_filter]{auk_filter()}}.}

\item{sep}{character; single character used to separate fields within a row.}

\item{unique}{logical; should duplicate grouped checklists be removed. If
\code{unique = TRUE}, \code{\link[=auk_unique]{auk_unique()}} is called on the EBD before returning.}

\item{rollup}{logical; should taxonomic rollup to species level be applied.
If \code{rollup = TRUE}, \code{\link[=auk_rollup]{auk_rollup()}} is called on the EBD before returning.
Note that this process can be time consuming for large files, try turning
rollup off if reading is taking too long.}
}
\value{
A data frame of EBD observations. An additional column,
\code{checklist_id}, is added to output files if \code{unique = TRUE}, that uniquely
identifies the checklist from which the observation came. This field is
equal to \code{sampling_event_identifier} for non-group checklists, and
\code{group_identifier} for group checklists.
}
\description{
Read an eBird Basic Dataset file using \code{\link[readr:read_delim]{readr::read_delim()}}. \code{read_ebd()}
reads the EBD itself, while read_sampling()` reads a sampling event data
file.
}
\details{
This functions performs the following processing steps:
\itemize{
\item Data types for columns are manually set based on column names used in the
February 2017 EBD. If variables are added or names are changed in later
releases, any new variables will have data types inferred by the import
function used.
\item Variables names are converted to \code{snake_case}.
\item Duplicate observations resulting from group checklists are removed using
\code{\link[=auk_unique]{auk_unique()}}, unless \code{unique = FALSE}.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Filename of EBD.

\item \code{auk_ebd}: \code{auk_ebd} object output from \code{\link[=auk_filter]{auk_filter()}}

\item \code{character}: Filename of sampling event data file

\item \code{auk_ebd}: \code{auk_ebd} object output from \code{\link[=auk_filter]{auk_filter()}}. Must have
had a sampling event data file set in the original call to \code{\link[=auk_ebd]{auk_ebd()}}.

\item \code{auk_sampling}: \code{auk_sampling} object output from \code{\link[=auk_filter]{auk_filter()}}.
}}

\examples{
f <- system.file("extdata/ebd-sample.txt", package = "auk")
read_ebd(f)
# read a sampling event data file
x <- system.file("extdata/zerofill-ex_sampling.txt", package = "auk") \%>\%
  read_sampling()
}
\seealso{
Other import: 
\code{\link{auk_zerofill}()}
}
\concept{import}
