% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-project.r
\name{auk_project}
\alias{auk_project}
\title{Filter the eBird data by project code}
\usage{
auk_project(x, project)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{project}{character; project code to filter by (e.g. \code{"EBIRD_MEX"}).
Multiple codes are accepted.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Some eBird records are collected as part of a particular project (e.g. the
Virginia Breeding Bird Survey) and have an associated project code in the
eBird dataset (e.g. EBIRD_ATL_VA). This function only defines the filter and,
once all filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK
and perform the filtering.
}
\details{
This function can also work with on an \code{auk_sampling} object if the
user only wishes to filter the sampling event data.
}
\examples{
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_project("EBIRD_MEX")
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_project(ebd, "EBIRD_MEX")
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_country}()},
\code{\link{auk_county}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
