% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-date.r
\name{auk_date}
\alias{auk_date}
\title{Filter the EBD by date}
\usage{
auk_date(x, date)
}
\arguments{
\item{x}{\code{auk_ebd} object; reference to EBD file created by \code{\link[=auk_ebd]{auk_ebd()}}.}

\item{date}{character or date; date range to filter by , provided either as a
character vector in the format \code{"2015-12-31"} or a vector of Date objects.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a range of dates.
This function only defines the filter and, once all filters have been
defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\examples{
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_date(date = c("2010-01-01", "2010-12-31"))
}
