% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals_autocorrelation}
\alias{check_residuals_autocorrelation}
\title{Checks for autocorrelation in target variable or in residuals}
\usage{
check_residuals_autocorrelation(object, method = "pearson")
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{method}{will be passed to the cor.test functions}
}
\value{
autocorrelation between target variable and between residuals
}
\description{
Checks for autocorrelation in target variable or in residuals
}
\examples{
library(DALEX)
dragons <- DALEX::dragons[1:100, ]
lm_model <- lm(life_length ~ ., data = dragons)
lm_exp <- explain(lm_model, data = dragons, y = dragons$life_length)
library(auditor)
check_residuals_autocorrelation(lm_exp)
}
