% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.data.R
\name{compile.data}
\alias{compile.data}
\title{Compile genetic and other non-genetic data}
\usage{
compile.data(x, add.x, method = "common")
}
\arguments{
\item{x}{A returned object (list) from the function read.genpop() or reduce.allele().}

\item{add.x}{A file containing non-genetic data that has sample ID in the first column. The sample ID must be the same as your GENEPOP file.}

\item{method}{A method to match sample ID between genetic and non-genetic data. The "common" method only concatenate the data that has sample ID in both files. If an individual only exists in one of the files, this individual will be discarded.}
}
\value{
This function returns a new object (list) that comprises 5 items. [[1]] data matrix including genetic and non-genetic data, [[2]] a sample ID vector, [[3]] a locus name vector, [[4]] a vector of non-genetic variable names, and [[5]] the number of non-genetic variables.
}
\description{
This function allows you to combine genetic and other non-genetic data, such as morphometrics, of the observations for assignment tests.
}
\examples{
genin <- read.Genepop(system.file("extdata/TinyGenepop.txt", package="assignPOP"))
comin <- compile.data(x=genin, add.x=system.file("extdata/TinyVars.csv", package="assignPOP"))
#Change file 'TinyVars' to 'morphData' to get the example used in the tutorial.
}

