% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asm.R
\name{asm}
\alias{asm}
\title{Linear regression via antitonic score matching}
\usage{
asm(formula, data = NULL, ...)
}
\arguments{
\item{formula}{regression formula}

\item{data}{input data frame}

\item{...}{additional arguments for asm.fit}
}
\value{
\code{asm} class object containing the following components:
\describe{
 \item{\code{betahat}:}{vector of estimated coefficients}
 \item{\code{std_errs}:}{vector of standard errors of the estimated coefficients}
 \item{\code{fitted.values}:}{fitted values}
 \item{\code{residuals}:}{residuals}
 \item{\code{zvals}:}{z-values}
 \item{\code{sig_vals}:}{p-values}
 \item{\code{info_asm}:}{antitonic information}
 \item{\code{I_mat}:}{estimated antitonic information matrix}
 \item{\code{Cov_mat}:}{covariance matrix of the estimated coefficients}
 \item{\code{psi}:}{estimated antitonic score function}
}
}
\description{
Performs linear regression with a data-driven convex loss function
}
\examples{
asm(mpg ~ cyl + hp + disp, data=mtcars)
}
