/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class NBMiner {
    private SparseSetOfItemsets db;
    private R_result result;
    private double pi;
    private double theta;
    private double k;
    private double a;
    private int n;
    private int maxlen;
    private boolean rules;
    private Hashtable repository = new Hashtable();
    private HashSet nbFrequentIS = new HashSet();
    private HashSet nbFrequentRules = new HashSet();
    private boolean verbatim = false;
    private boolean debug = false;
    private NumberFormat nf = NumberFormat.getInstance();
    private PrintStream output;

    public R_result R_mine(SparseSetOfItemsets sparseSetOfItemsets, double d, double d2, double d3, double d4, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.db = sparseSetOfItemsets;
        this.pi = d;
        this.theta = d2;
        this.k = d4;
        this.a = d3;
        this.n = n;
        this.maxlen = bl ? n2 - 1 : n2;
        this.rules = bl;
        this.verbatim = bl2;
        this.debug = bl3;
        this.output = System.out;
        this.nf.setMaximumFractionDigits(5);
        this.nf.setMinimumFractionDigits(5);
        this.run();
        this.result = bl ? new R_result(this.nbFrequentRules, sparseSetOfItemsets.items(), true) : new R_result(this.nbFrequentIS, sparseSetOfItemsets.items(), false);
        return this.result;
    }

    public void run() {
        if (this.verbatim) {
            this.output.println("Depth-first NB-frequent itemset miner by Michael Hahsler");
            this.output.println("Database with " + this.db.size() + " transactions" + " and " + this.db.items() + " unique items");
            this.output.println();
        }
        Vector<Integer> vector = new Vector<Integer>(this.db.size());
        for (int i = 0; i < this.db.size(); ++i) {
            vector.add(new Integer(i));
        }
        Itemset itemset = new Itemset();
        this.DFS(itemset, vector);
        if (this.verbatim) {
            if (this.rules) {
                this.output.println(this.nbFrequentRules.size() + " NB-precide rules found.");
            } else {
                this.output.println(this.nbFrequentIS.size() + " NB-frequent itemsets found.");
            }
        }
    }

    public void DFS(Itemset itemset, Vector vector) {
        Vector<Itemset> vector2;
        int n;
        if (this.debug) {
            this.output.println("# Doing DFS for " + itemset);
        }
        if (vector == null) {
            if (this.debug) {
                this.output.println("Warning: " + itemset + " does not occur in any transaction - dropped!");
            }
            return;
        }
        int[] nArray = new int[this.db.items()];
        Vector[] vectorArray = new Vector[this.db.items()];
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            Itemset itemset2 = this.db.getItemset(n2);
            for (n = 0; n < itemset2.size(); ++n) {
                int n3 = itemset2.get(n);
                if (itemset.contains(n3)) continue;
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
                if (vectorArray[n3] == null) {
                    vectorArray[n3] = new Vector();
                }
                vectorArray[n3].add(new Integer(n2));
            }
        }
        if (!itemset.isEmpty()) {
            vector2 = this.NBSelect(nArray, itemset);
        } else {
            vector2 = new Vector<Itemset>(this.db.items());
            for (n = 0; n < this.db.items(); ++n) {
                vector2.add(new Itemset(n));
            }
            if (this.debug) {
                this.output.println("Added " + vector2.size() + " items for initial run.");
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            Itemset itemset3 = (Itemset)vector2.get(n);
            Integer n5 = (Integer)this.repository.get(itemset3);
            int n6 = n5 == null ? 0 : n5;
            this.repository.put(itemset3, new Integer(++n6));
            if (this.debug) {
                this.output.println(itemset3 + " - count in repository: " + n6);
            }
            if ((double)n6 >= this.theta * (double)itemset3.size() && itemset3.size() <= this.maxlen && !this.nbFrequentIS.contains(itemset3)) {
                this.nbFrequentIS.add(itemset3);
                if (this.debug) {
                    this.output.println(itemset3 + " - is NB-frequent\n");
                }
                this.DFS(itemset3, vectorArray[itemset3.getCurrentItem()]);
            }
            if (!this.debug) continue;
            this.output.println("Backtracking...");
        }
    }

    public Vector NBSelect(int[] nArray, Itemset itemset) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.n - itemset.size();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n3 < nArray[n2]) {
                n3 = nArray[n2];
            }
            n4 += nArray[n2];
        }
        int[] nArray2 = new int[n3 + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n6 = nArray[n2];
            nArray2[n6] = nArray2[n6] + 1;
        }
        double d = this.a * (double)n4;
        double[] dArray = new double[n3 + 1];
        dArray[n3] = n5;
        dArray[0] = (double)n5 * Math.pow(1.0 + d, -1.0 * this.k);
        int n7 = n3;
        dArray[n7] = dArray[n7] - dArray[0];
        for (n = 0; n < n3 - 1; ++n) {
            dArray[n + 1] = (this.k + (double)n) / (double)(n + 1) * d / (1.0 + d) * dArray[n];
            int n8 = n3;
            dArray[n8] = dArray[n8] - dArray[n + 1];
        }
        if (this.debug) {
            this.output.println("NBSelect for l=" + itemset);
            this.output.println("\tk: " + this.k);
            this.output.println("\titem co-occurrences: " + n4);
            this.output.println("\ta (rescaled): " + d);
            this.output.println("\tr_max: " + n3);
            this.output.println("\tpi: " + this.pi);
            this.output.println("\tr\tnObs\tnModel\tprecision");
        }
        n = n3;
        int n9 = 0;
        double d2 = 0.0;
        double[] dArray2 = new double[n3 + 1];
        do {
            dArray2[n] = 1.0 - (d2 += dArray[n]) / (double)(n9 += nArray2[n]);
            if (!this.debug) continue;
            this.output.println("\t" + n + "\t" + nArray2[n] + "\t" + this.nf.format(dArray[n]) + "\t" + this.nf.format(dArray2[n]));
        } while (dArray2[n] >= this.pi && n-- > 0);
        if (n3 < 2) {
            if (this.debug) {
                this.output.println("-> not enough co-occurrences (rMax < 2)!\n");
            }
            return new Vector(0);
        }
        Vector<Itemset> vector = new Vector<Itemset>(n9 - nArray2[n]);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= n) continue;
            vector.add(new Itemset(itemset, n2, dArray2[nArray[n2]]));
            if (!this.rules) continue;
            this.nbFrequentRules.add(new Rule(itemset, new Itemset(n2), dArray2[nArray[n2]]));
        }
        if (this.debug) {
            this.output.print("-> found " + vector.size() + " item(s) with r>" + n + ": C={");
            for (n2 = 0; n2 < vector.size(); ++n2) {
                Itemset itemset2 = (Itemset)vector.get(n2);
                this.output.print(itemset2.getCurrentItem() + ", ");
            }
            this.output.println("\b\b}");
        }
        return vector;
    }
}

