% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{arrApply}
\alias{arrApply}
\title{High Performance Variant of apply()}
\usage{
arrApply(arr, idim = 1L, fun = "sum")
}
\arguments{
\item{arr}{numeric array of arbitrary dimension}

\item{idim}{integer, dimension number along which a function must be applied}

\item{fun}{character string, function name to be applied}
}
\value{
output array of dimension cut by 1. Its type (nueric or logical)
depends on the function applied.
}
\description{
High performance variant of apply() for a fixed set of functions.
However, a considerable speedup is a trade-off for universality.
Only the following functions can be applied: sum(), prod(), all(), any(), min(), max(),
mean(), median(), sd(), var().
}
\details{
RcppArmadillo is used to do the job very quickly but it commes at price
of not allowing NA in the input numeric array.
Vectors are allowed at input. They are considered as arrays of dimension 1.
So in this case, \code{idim} must be 1.
}
\examples{
 arr=matrix(1:12, 3, 4)
 v1=arrApply(arr, 2, "mean")
 v2=rowMeans(arr)
 stopifnot(all(v1==v2))
 
 arr=array(1:24, dim=2:4) # dim(arr)=c(2, 3, 4)
 mat=arrApply(arr, 2, "prod") # dim(mat)=c(2, 4), the second dimension is cut out
 stopifnot(all(mat==apply(arr, c(1, 3), prod)))

}
\author{
Serguei Sokol <sokol at insa-toulouse.fr>
}

