% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/keep.R
\docType{methods}
\name{keep}
\alias{keep}
\alias{keep-method}
\alias{keep_cols}
\alias{keep_cols-method}
\alias{keep_rows}
\alias{keep_rows-method}
\alias{keep,ANY-method}
\alias{keep_rows,ANY-method}
\alias{keep_cols,ANY-method}
\title{Keep Rows/Columns Using a Predicate}
\usage{
keep(x, ...)

keep_cols(x, ...)

keep_rows(x, ...)

\S4method{keep}{ANY}(
  x,
  f,
  margin = 1,
  negate = FALSE,
  all = FALSE,
  verbose = getOption("arkhe.verbose"),
  ...
)

\S4method{keep_rows}{ANY}(
  x,
  f,
  negate = FALSE,
  all = FALSE,
  verbose = getOption("arkhe.verbose"),
  ...
)

\S4method{keep_cols}{ANY}(
  x,
  f,
  negate = FALSE,
  all = FALSE,
  verbose = getOption("arkhe.verbose"),
  ...
)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Further arguments to be passed to \code{f}.}

\item{f}{A predicate \code{\link{function}}.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscripts which the
function will be applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{negate}{A \code{\link{logical}} scalar: should the negation of \code{f} be used
instead of \code{f}?}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}
}
\description{
Keeps rows/columns in an array-like object using a predicate function.
}
\examples{
## Create a data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Keep row without any NA
keep(X, f = is.na, margin = 1, negate = TRUE, all = TRUE)
## Keep row without any NA
keep(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)
}
\seealso{
Other data cleaning tools: 
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{empty}},
\code{\link{infinite}},
\code{\link{missing}},
\code{\link{remove_constant}()},
\code{\link{zero}}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
