% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace.R
\docType{methods}
\name{replace_NA}
\alias{replace_NA}
\alias{replace_NA-method}
\alias{replace_NA,matrix-method}
\alias{replace_NA,data.frame-method}
\title{Replace Missing Values}
\usage{
replace_NA(x, ...)

\S4method{replace_NA}{matrix}(x, value = 0)

\S4method{replace_NA}{data.frame}(x, value = 0)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{value}{A possible replacement value.}
}
\description{
Replaces \link[=NA]{missing values} values.
}
\examples{
## Create a data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Remove rows with NA
remove_NA(X, margin = 1)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{clean_whitespace}()},
\code{\link{remove_Inf}()},
\code{\link{remove_NA}()},
\code{\link{remove_constant}()},
\code{\link{remove_empty}()},
\code{\link{remove_zero}()},
\code{\link{replace_Inf}()},
\code{\link{replace_empty}()},
\code{\link{replace_zero}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
