\name{plot.predarfima}
\alias{plot.predarfima}

\title{
Plots the original time series, the predictions, and the prediction intervals for a \code{predarfima} object. 
}
\description{
This function takes a \code{predarfima} object generated by \code{predict.arfima} and plots all of the information contained in it.  The colour code is as follows:

grey: exact prediction
red: exact prediction intervals (PIs)
orange: limiting PIs
blue:  (residual) bootstrap prediction and PIs

See \code{\link{predict.arfima}}. 
}
\usage{
\method{plot}{predarfima}(x, xlab = NULL, ylab = NULL,
main = NULL, ylim = NULL, numback = 5, xlim = NULL, ...) 
}

\arguments{
  \item{x}{
A \code{predarfima} object
}
  \item{xlab}{
Optional
}
  \item{ylab}{
Optional
}
  \item{main}{
Optional
}
  \item{ylim}{
Optional
}  
  \item{numback}{
The number of last values of the original series to plot defined by the user. The default is five
}
  \item{xlim}{
Optional
}
  \item{\dots}{
Currently not used
}
}

\value{
None. Generates a plot
}
\references{
Veenstra, J. and McLeod, A. I. (Working Paper).
The arfima R package: Exact Methods for Hyperbolic Decay Time Series

}
\author{
Justin Veenstra
}

\seealso{
\code{\link{predict.arfima}}, \code{\link{print.predarfima}}
}
\examples{
\dontrun{
set.seed(82365)
sim <- arfima.sim(1000, model = list(dfrac = 0.4, theta=0.9, dint = 1))
fit <- arfima(sim, order = c(0, 1, 1))
fit
pred <- predict(fit, n.ahead = 5)
pred
plot(pred)
}
}
\keyword{ ts}