% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchVars.R
\name{matchVars}
\alias{matchVars}
\title{Determine the valid ID of variables}
\usage{
matchVars(input = NULL, source = NULL, ...)
}
\arguments{
\item{input}{[\code{character(.)}]\cr table in which to match variables.}

\item{source}{[\code{integerish(1)}]\cr the census ID (\code{cenID}) from
which the terms have been taken.}

\item{...}{[\code{list(1)}]\cr lists that capture the variables by which to
match and the new column names containing the resulting ID; see Details.}
}
\value{
The table provided in \code{input}, where the given variable is
  replaced by the column that is specified by the argument name.
}
\description{
This function matches the values of a variable with an index and returns the
specified IDs.
}
\details{
Arguments in \code{...} are named lists that indicate with which
  target column variables shall be matched and which value should be used as
  target ID.

  targetID = list(variable = targetColumn)

  The variable must be present as column in \code{input} and a table that is
  named "id_VARIABLE.csv" must be available in the root directory of the
  project. This should have been created with \code{\link{setVariables}}.
}
