% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyToRepo.R
\name{copyLocalRepo}
\alias{copyLocalRepo}
\alias{copyRemoteRepo}
\title{Copy an Existing Repository into Another Repository}
\usage{
copyLocalRepo(repoFrom = NULL, repoTo, md5hashes)

copyRemoteRepo(repoTo, md5hashes, repo = aoptions("repo"),
  user = aoptions("user"), branch = aoptions("branch"),
  subdir = aoptions("subdir"), repoType = aoptions("repoType"))
}
\arguments{
\item{repoFrom}{While copying local repository. A character that specifies
the directory of the Repository from which
artifacts will be copied. If it is set to \code{NULL} (by default),
it will use the \code{repoDir} specified in \link{setLocalRepo}.}

\item{repoTo}{A character that specifies the directory of the Repository into which
artifacts will be copied.}

\item{md5hashes}{A character vector containing \code{md5hashes} of artifacts to be copied.}

\item{repo}{While coping the remote repository. A character containing a name of the
remote repository on which the "\code{repoFrom}" - Repository is archived.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{While coping the remote repository. A character containing a name
of the remote user on whose account the "\code{repoFrom}" - Repository is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{While coping with the remote repository. A character containing a name of 
Remote Repository's branch on which the "\code{repoFrom}" - Repository is archived.
Default \code{branch} is \code{master}.}

\item{subdir}{While working with the remote repository. A character containing a name of
a directory on the remote repository on which the "\code{repoFrom}" - Repository is stored.
If the Repository is stored in the main folder on the remote repository, this should be set 
to \code{FALSE} as default.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'Remote' or 'bitbucket'.}
}
\description{
\code{copy*Repo} copies artifacts from one \code{Repository} into another \code{Repository}.
It adds new files to existing \code{gallery} folder in \code{repoTo} \code{Repository}.
\code{copyLocalRepo} copies local \code{Repository} while \code{copyRemoteRepo} copies
remote \code{Repository}.
}
\details{
Functions \code{copyLocalRepo} and \code{copyRemoteRepo} copy artifacts from the
archivist's Repositories stored in a local folder or on the Remote. 
Both of them use \code{md5hashes} of artifacts which are to be copied 
in \code{md5hashes} parameter. For more information about \code{md5hash} see \link{md5hash}.
}
\note{
If \code{repo} and \code{user} are set to \code{NULL} (as default) in remote mode then global parameters
set in \link{setRemoteRepo} function are used. If one would like to copy whole Repository we suggest to 
extract all \code{md5hashes} in this way \code{unique(showLocalRepo(repoDir)[,1])}.

Bug reports and feature requests can be sent to \href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}
\examples{
\dontrun{


## Using archivist remote Repository to copy artifacts
# creating example Repository
 
exampleRepoDir <- tempfile()
createLocalRepo( exampleRepoDir )

# Searching for md5hashes of artifacts (without data related to them)
# in the archivist remote  Repository
hashes <- searchInRemoteRepo( pattern="name", user="pbiecek", repo="archivist", fixed=FALSE )

# Copying selected artifacts from archivist Remote  Repository into exampleRepoDir Repository

copyRemoteRepo( repoTo = exampleRepoDir , md5hashes= hashes, user="pbiecek", repo="archivist" )

# See how the gallery folder in our exampleRepoDir Repository
# with copies of artifacts from archivist Remote  Repository looks like
list.files( path = file.path( exampleRepoDir, "gallery" ) )

# See how the backpack database in our exampleRepoDir Repository looks like
showLocalRepo( repoDir = exampleRepoDir )

# removing an example Repository

deleteLocalRepo( exampleRepoDir, deleteRoot=TRUE )

rm( exampleRepoDir )

# many archivist-like Repositories on one Remote repository

dir <- paste0(getwd(), "/ex1")
createLocalRepo( dir )
copyRemoteRepo( repoTo = dir , md5hashes = "ff575c261c949d073b2895b05d1097c3",
                user="MarcinKosinski", repo="Museum",
                branch="master", subdir="ex2")
                
# Check if the copied artifact is on our dir Repository

showLocalRepo( repoDir = dir) # It is in backpack database indeed
list.files( path = file.path( dir, "gallery" ) ) # it is also in gallery folder

# removing an example Repository
deleteLocalRepo( dir, TRUE)

rm(dir)

## Using graphGallery Repository attached to the archivist package to copy artifacts

# creating example Repository

exampleRepoDir <- tempfile()
createLocalRepo( exampleRepoDir )

# Searching for md5hashes of artifacts (without data related to them)
# in the graphGallery  Repository
archivistRepo <- system.file( "graphGallery", package = "archivist")
# You may use: 
# hashes <- unique(showLocalRepo(repoDir)[,1]) 
# to extract all artifacts from repository
hashes <- searchInLocalRepo( pattern="name",
                             repoDir =  archivistRepo,
                             fixed=FALSE )

# Copying selected artifacts from archivist Remote  Repository into exampleRepoDir Repository

copyLocalRepo( repoFrom = archivistRepo, repoTo = exampleRepoDir , md5hashes= hashes )

# See how the backpack database in our exampleRepoDir Repository looks like
showLocalRepo( repoDir = exampleRepoDir )

# removing an example Repository

deleteLocalRepo( exampleRepoDir, deleteRoot=TRUE )

rm( exampleRepoDir )
rm( archivistRepo )

}


}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

