% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-parse-esri-json.R
\name{parse_esri_json}
\alias{parse_esri_json}
\title{Parse Esri JSON}
\usage{
parse_esri_json(string, ..., call = rlang::caller_env())
}
\arguments{
\item{string}{the raw Esri JSON string.}

\item{...}{additional arguments passed to \code{\link[RcppSimdJson:fparse]{RcppSimdJson::fparse}}}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
A data.frame. If geometry is found, returns an sf object.
}
\description{
Parses an Esri FeatureSet JSON object into an R object. If there is no
geometry present, a data.frame is returned. If there is geometry, an sf object is returned.
}
\examples{

esri_json <- '{
    "geometryType": "esriGeometryPolygon",
    "spatialReference": {
        "wkid": 4326
    },
    "hasZ": false,
    "hasM": false,
    "features": [
        {
            "attributes": {
                "id": 1
            },
            "geometry": {
                "rings": [
                    [
                        [0.0, 0.0],
                        [1.0, 0.0],
                        [1.0, 1.0],
                        [0.0, 1.0],
                        [0.0, 0.0]
                    ]
                ]
            }
        }
    ]
}'

parse_esri_json(esri_json)

}
