% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-place-details.R
\name{place_details}
\alias{place_details}
\title{Get place details including name, address, description, and other attributes}
\usage{
place_details(
  place_id,
  requested_fields,
  icon = NULL,
  token = arc_token(),
  .progress = TRUE
)
}
\arguments{
\item{place_id}{a character vector of place IDs as generated by \code{within_extent()} or \code{near_point()}.}

\item{requested_fields}{Required. See \href{https://developers.arcgis.com/rest/places/place-id-get/#requestedfields}{API Reference} for possible fields or refer to the \code{\link{fields}} vector.}

\item{icon}{Default \code{NULL}. Must be one of \code{"svg"}, \code{"png"} \code{"cim"}. Determines whether icons are returned and the type of icon to use with a place or category.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}

\item{.progress}{Default \code{TRUE}. Whether a progress bar should be provided.}
}
\value{
an sf object
}
\description{
The \verb{/places/\{placeId\}} request returns details for a place.
}
\details{
To request details, you use the \code{requested_fields} argument to specify the fields and the attributes you want from the Place, Address, Details and/or Location price groups.

It is always recommended to specify the fields you want, however, you can also use \code{requested_fields=all} to return all of the attributes available. By default, The \code{place_id} attribute is always returned in addition to the other attributes you requested.

The attributes available for places may vary. For example, opening hours may not be available (or applicable) for geographic places or landmarks.

You will only be charged for attributes that contain valid values for the requested fields. If no data is available for the requested field, null or an empty collection is returned and you are not charged. You are only charged once if one or more attributes with valid values are returned from a price group.
}
\examples{
\dontrun{
place_ids <- c(
  "37f1062ae1c3d37511003e382b08ca32",
  "9cdd210841deedef0e3309bdd3fe47f1"
)

res <- place_details(place_ids)
}
}
\references{
\href{https://developers.arcgis.com/rest/places/place-id-get/}{API Documentation}
}
