% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_item.R
\name{add_item}
\alias{add_item}
\alias{publish_item}
\alias{publish_layer}
\alias{.publish_params}
\title{Publish Content}
\usage{
add_item(
  x,
  title,
  description = "",
  tags = character(0),
  snippet = "",
  categories = character(0),
  async = FALSE,
  type = "Feature Service",
  token = arc_token()
)

publish_item(
  item_id,
  publish_params = .publish_params(),
  file_type = "featureCollection",
  token = arc_token()
)

publish_layer(
  x,
  title,
  ...,
  publish_params = .publish_params(title, target_crs = sf::st_crs(x)),
  token = arc_token()
)

.publish_params(
  name = NULL,
  description = NULL,
  copyright = NULL,
  target_crs = 3857,
  max_record_count = 2000L
)
}
\arguments{
\item{x}{an object of class \code{data.frame}. This can be an \code{sf} object or \code{tibble} or
any other subclass of \code{data.frame}.}

\item{title}{A user-friendly string title for the layer that can be used in
a table of contents.}

\item{description}{a length 1 character vector containing the description of
the item that is being added. Note that the value cannot be larger than 64kb.}

\item{tags}{a character vector of tags to add to the item.}

\item{snippet}{a length 1 character vector with no more than 2048 characters.}

\item{categories}{a character vector of the categories of the item.}

\item{async}{default \code{FALSE}. Cannot be changed at this time.}

\item{type}{default \code{"Feature Service"}. Must not be changed at this time.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}

\item{item_id}{the ID of the item to be published.}

\item{publish_params}{a list of named values of the \code{publishParameters}. Must match
the values in the \href{https://developers.arcgis.com/rest/users-groups-and-items/publish-item.htm#GUID-9E8F8526-5D58-4706-95F3-432905CC3303}{/publish endpoint documentation}.}

\item{file_type}{default \code{"featureCollection"}. Cannot be changed.}

\item{...}{arguments passed into \code{add_item()}.}

\item{name}{a scalar character of the name of the layer. Must be unique.}

\item{copyright}{an optional character scalar containing copyright text to
add to the published Feature Service.}

\item{target_crs}{the CRS of the Feature Service to be created. By default,
\code{EPSG:3857}.}

\item{max_record_count}{the maximum number of records that can be returned
from the created Feature Service.}
}
\value{
A named list containing the url of the newly published service.
}
\description{
Publishes an \code{sf} or \code{data.frame} object to an ArcGIS Portal as a
FeatureCollection.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{add_item()} takes a data.frame like object and uploads it as an item in
your portal.
\item \code{publish_item()} takes an ID of an item in your portal and publishes it
as a feature service.
\item \code{publish_layer()} is a high-level wrapper that first adds an object as
an item in your portal and subsequently publishes it for you.
\item \code{.publish_params()} is a utility function to specify optional publish
parameters such as copyright text, and the spatial reference of the
published feature collection.
}

Note that there is \emph{only} support for feature services meaning that only
tables and feature layers can be made by these functions.
\subsection{Publish Parameters}{

When publishing an item to a portal, a number of \href{https://developers.arcgis.com/rest/users-groups-and-items/publish-item.htm#GUID-9E8F8526-5D58-4706-95F3-432905CC3303}{publish parameters} can be provided. Most importantly is the \code{targetSR} which will be
the CRS of the hosted feature service. By default this is \code{EPSG:3857}.

\code{publish_layer()} will use the CRS of the input object, \code{x}, by default. If
publishing content in two steps with \code{add_item()} and \code{publish_item()}, use
\code{.publish_params()} to craft your publish parameters. Ensure that the CRS
provided to \code{target_crs} matches that of the item you added with
\code{add_item()}.
}
}
\examples{
\dontrun{
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"))
  x <- nc[1:5, 13]

  token <- auth_code()
  set_arc_token(token)

  publish_res <- publish_layer(
    x, "North Carolina SIDS sample"
  )
}
}
