% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-definition.R
\name{add_layer_definition}
\alias{add_layer_definition}
\alias{update_layer_definition}
\alias{delete_layer_definition}
\title{Add, update, or delete a Feature Layer definition}
\usage{
add_layer_definition(x, ..., async = FALSE, token = arc_token())

update_layer_definition(x, ..., async = FALSE, token = arc_token())

delete_layer_definition(x, ..., async = FALSE, token = arc_token())
}
\arguments{
\item{x}{A Feature Layer, Table, or Feature Service class object.}

\item{...}{Additional parameters for the "addToDefinition" or "updateDefinition" body of the request.}

\item{async}{Default \code{FALSE}. If \code{TRUE}, support asynchronous processing for
the request.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
If \code{async = FALSE}, return an updated "FeatureServer" or "FeatureLayer" object with the added, updated, or deleted definitions. If \code{async = TRUE}, the input Feature Layer or Feature Server object \code{x} is returned as is.
}
\description{
Each layer of a feature service is defined by a "definition." The definition
describes the service such as its fields, symbology, indexes and more.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item Use \code{\link[=add_layer_definition]{add_layer_definition()}} for adding fields to a feature service or otherwise
adding to the definition of a feature layer.
\item Use \code{\link[=update_layer_definition]{update_layer_definition()}} to modify existing aspects of the definition properties.
\item Use \code{\link[=delete_layer_definition]{delete_layer_definition()}} to delete properties from the layer definition.
}

Examples of properties include the layer name, renderer, or field properties. Named parameters
passed to \code{...} must have names matching supported definitions.
Parameters are converted to a JSON \code{addToDefinition}, \code{updateDefinition}, or
\code{deleteFromDefinition} query parameter using \code{\link[jsonify:to_json]{jsonify::to_json()}}.

See the ArcGIS REST API documentation on Administer Hosted Feature Services
for more details:
\itemize{
\item see the \href{https://developers.arcgis.com/web-map-specification/objects/layerDefinition/}{layerDefinition} object documentation.
\item adding definitions for a \href{https://developers.arcgis.com/rest/services-reference/online/add-to-definition-feature-layer/}{FeatureLayer} or \href{https://developers.arcgis.com/rest/services-reference/online/add-to-definition-feature-service/}{a FeatureService}
\item updating definitions for \href{https://developers.arcgis.com/rest/services-reference/online/update-definition-feature-layer/}{a FeatureLayer} or \href{https://developers.arcgis.com/rest/services-reference/online/update-definition-feature-service-.htm}{a FeatureService}
\item deleting definitions for \href{https://developers.arcgis.com/rest/services-reference/online/delete-from-definition-feature-layer/}{a FeatureLayer} or a \href{https://developers.arcgis.com/rest/services-reference/online/delete-from-definition-feature-service/}{FeatureService}
}
}
\examples{
\dontrun{
if (interactive()) {
# authenticate
set_arc_token(auth_code())

# publish a layer
published <- publish_layer(penguins, "Penguin Test")

penguin_fl <- arc_open(published$services$encodedServiceURL) |>
  get_layer(0)

# Update the name of the layer
update_layer_definition(
  penguin_fl,
  name = "New Layer Name"
)

# add an index on the the layer
add_layer_definition(
  penguin_fl,
  indexes = list(
    name = "index1",
    fields = "species",
    isUnique = FALSE,
    isAscending = FALSE,
    description = "Example index"
  )
)

# refresh the layer to get the updates
penguin_fl <- refresh_layer(penguin_fl)
penguin_fl[["indexes"]]
}
}
}
