% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-read.R
\name{arc_read}
\alias{arc_read}
\title{Read an ArcGIS FeatureLayer, Table, or ImageServer}
\usage{
arc_read(
  url,
  col_names = TRUE,
  col_select = NULL,
  n_max = Inf,
  name_repair = "unique",
  crs = NULL,
  ...,
  fields = NULL,
  alias = "drop",
  token = arc_token()
)
}
\arguments{
\item{url}{a url to a service such as a feature service, image server, or map server. Alternatively, an item ID of a portal item or portal url.}

\item{col_names}{Default \code{TRUE}. Column names or name handling rule.
\code{col_names} can be \code{TRUE}, \code{FALSE}, \code{NULL}, or a character vector:
\itemize{
\item If \code{TRUE}, use existing default column names for the layer or table.
If \code{FALSE} or \code{NULL}, column names will be generated automatically: X1, X2,
X3 etc.
\item If \code{col_names} is a character vector, values replace the existing column
names. \code{col_names} can't be length 0 or longer than the number of fields in
the returned layer.
}}

\item{col_select}{Default \code{NULL}. A character vector of the field names to be
returned. By default, all fields are returned.}

\item{n_max}{Defaults to \code{Inf} or an option set with
\verb{options("arcgislayers.n_max" = <max records>)}. Maximum number of records
to return.}

\item{name_repair}{Default \code{"unique"}. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for
details. If \code{name_repair = NULL} and \code{alias = "replace"} may include
invalid names.}

\item{crs}{the spatial reference to be returned. If the CRS is different than
the CRS for the input \code{FeatureLayer}, a transformation will occur
server-side. Ignored if x is a \code{Table}.}

\item{...}{Additional arguments passed to \code{\link[=arc_select]{arc_select()}} if URL is a
\code{FeatureLayer} or \code{Table} or \code{\link[=arc_raster]{arc_raster()}} if URL is an \code{ImageLayer}.}

\item{fields}{Default \code{NULL}. a character vector of the field names to
returned. By default all fields are returned. Ignored if \code{col_names} is
supplied.}

\item{alias}{Use of field alias values. Default \verb{c("drop", "label", "replace"),}. There are three options:
\itemize{
\item \code{"drop"}, field alias values are ignored.
\item \code{"label"}: field alias values are assigned as a label attribute for each field.
\item \code{"replace"}: field alias values replace existing column names. \code{col_names}
}}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
An sf object, a \code{data.frame}, or an object of class \code{SpatRaster}.
}
\description{
\code{\link[=arc_read]{arc_read()}} combines the functionality of \code{\link[=arc_open]{arc_open()}} with \code{\link[=arc_select]{arc_select()}}
or \code{\link[=arc_raster]{arc_raster()}} to read an ArcGIS \code{FeatureLayer}, \code{Table}, or \code{ImageServer}
to an \code{sf} or \code{SpatRaster} object. Optionally, set, check, or modify names
for the returned data frame or sf object using the \code{col_names} and
\code{name_repair} parameters. For ease of use and convenience, \code{\link[=arc_read]{arc_read()}}
allows users to access and query a FeatureLayer, Table, or ImageServer with a
single function call instead of combining \code{\link[=arc_open]{arc_open()}} and \code{\link[=arc_select]{arc_select()}}.
The conventions of \code{col_select} are based on functions for reading tabular
data in the \code{{readr}} package.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
furl <- "https://sampleserver6.arcgisonline.com/arcgis/rest/services/Census/MapServer/3"

# read entire service
arc_read(furl)

# apply tolower() to column names
arc_read(url, name_repair = tolower)

# use paste0 to prevent CRAN check NOTE
furl <- paste0(
  "https://sampleserver6.arcgisonline.com/arcgis/rest/services/",
  "EmergencyFacilities/FeatureServer/0"
)

# use field aliases as column names
arc_read(furl, alias = "replace")

# read an ImageServer directly
img_url <- "https://landsat2.arcgis.com/arcgis/rest/services/Landsat/MS/ImageServer"

arc_read(
  img_url,
  width = 100, height = 100,
  xmin = -71, ymin = 43,
  xmax = -67, ymax = 47.5,
  bbox_crs = 4326
)
}
}
\seealso{
\code{\link[=arc_select]{arc_select()}}; \code{\link[=arc_raster]{arc_raster()}}
}
