% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slab-utils.R
\name{genSlabLabels}
\alias{genSlabLabels}
\title{Generate Labels for Slabs}
\usage{
genSlabLabels(
  slab.structure = 1,
  max.d = NULL,
  n.profiles = NULL,
  spc = NULL,
  diced = NULL,
  ...
)
}
\arguments{
\item{slab.structure}{A user-defined slab thickness (defined by an integer), or user-defined structure (numeric vector). See details for \code{slab()}.}

\item{max.d}{Maximum depth}

\item{n.profiles}{Number of profiles}

\item{spc}{Optional: A SoilProfileCollection}

\item{diced}{Optional: The \code{dice()}-ed horizon-level data.frame corresponding to \code{spc}}

\item{...}{Additional arguments passed to \code{dice()} when \code{spc} is specified.}
}
\value{
factor. slab IDs, labels are the segment top and bottom depth separated by \code{"-"}
}
\description{
This method is used by \code{\link[=slab]{slab()}} for generating labels that assign IDs to layers in a SoilProfileCollection
}
\details{
The new routine used in aqp 2.0 requires that, at a minimum, the \code{spc} and \code{slab.structure} arguments be specified.
}
\seealso{
\code{\link[=slab]{slab()}}
}
