% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-integrity.R
\docType{methods}
\name{spc_in_sync}
\alias{spc_in_sync}
\title{Quickly assess relative state of site and horizon slots}
\usage{
spc_in_sync(object)
}
\arguments{
\item{object}{A SoilProfileCollection}
}
\value{
data.frame
}
\description{
Determine "state" of SoilProfileCollection before or after major modifications of site or horizon slot contents.

Two logical checks are performed on the site and horizon tables, and a third element \code{valid} returns \code{TRUE} when both checks are \code{TRUE}.

Check 1: Same number of sites in site as number of sites in horizons. No intermingling of IDs, no orphan horizons, no sites without horizons (for now)

Check 2: Site IDs match coalesced profile ID from horizons. Ensures the same \emph{relative} ordering, but horizons still may be out of order within profiles
}
\author{
Andrew G. Brown

data(sp5)

spc_in_sync(sp5)
}
