% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignTransect.R
\name{alignTransect}
\alias{alignTransect}
\title{Calculate Relative Positions from Transect Data}
\usage{
alignTransect(x, x.min, x.max, fix = TRUE, ...)
}
\arguments{
\item{x}{numeric vector, describing values along a transect: distance, elevation, climatic variables, etc.. Typically sourced from the site level attributes of a \code{SoilProfileCollection} object. Order is not important.}

\item{x.min}{numeric, lower boundary to relative position scale}

\item{x.max}{numeric, upper boundary to relative position scale}

\item{fix}{logical, attempt fixing overlapping positions with \code{fixOverlap}}

\item{...}{additional arguments to \code{fixOverlap}}
}
\value{
\code{list} containing:
\itemize{
\item \code{grad}: values of \code{x} in ascending order
\item \code{order}: ordering vector of \code{x}
\item \code{relative.pos}: elements of \code{x} translated to the new relative scale defined by \code{x.min} and \code{x.max}
}
}
\description{
This function is used to support relative positioning of soil profiles by \code{plotSPC}, based on transect or gradient values typically associated with a site level attribute (e.g. elevation). Gradient values specified in \code{x} are translated to the range used by \code{plotSPC} (usually \verb{1, length(SPC)}) specified in \code{x.min} and \code{x.max}.
}
\examples{

data("sierraTransect")

# split transects
g <- subset(sierraTransect, transect == 'Granite')
a <- subset(sierraTransect, transect == 'Andesite')

g.p <- alignTransect(g$elev, x.min = 1, x.max = length(g), fix = FALSE)
a.p <- alignTransect(a$elev, x.min = 1, x.max = length(a), fix = FALSE)

op <- par(mar=c(2,0,0,2), mfrow=c(2,1))

plotSPC(g, width=0.25, name.style='center-center', 
        cex.names=0.75, 
        relative.pos = g.p$relative.pos, plot.order = g.p$order)

axis(1, at = g.p$relative.pos, labels = g.p$grad, line = -1.5)

plotSPC(a, width=0.25, name.style='center-center', 
        cex.names=0.75, 
        relative.pos = a.p$relative.pos, plot.order = a.p$order)

axis(1, at = a.p$relative.pos, labels = a.p$grad, line = -1.5)


par(op)

}
