% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_detach.R
\name{apollo_detach}
\alias{apollo_detach}
\title{Detaches parameters and the database.}
\usage{
apollo_detach(apollo_beta = NA, apollo_inputs = NA)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
Nothing.
}
\description{
Detaches variables attached by \link{apollo_attach}.
}
\details{
This function detaches the variables attached by \link{apollo_attach}. 
It should be called at the end of \code{apollo_probabilities}, only if 
\link{apollo_attach} was called and the beginning. This can be achieved 
by adding the line \code{on.exit(apollo_detach(apollo_beta, apollo_inputs))} 
right after calling \link{apollo_attach}.
This function can also be called without any arguments, i.e. \code{apollo_detach()}.
}
