% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_mnl_2.R
\name{apollo_mnl_2}
\alias{apollo_mnl_2}
\title{Calculates probabilities of a multinomial logit model.}
\usage{
apollo_mnl_2(mnl_settings, functionality)
}
\arguments{
\item{mnl_settings}{List of inputs of the MNL model. It should contain the following.
\itemize{
  \item \strong{\code{alternatives}}: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
  \item \strong{\code{avail}}: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1.
  \item \strong{\code{choiceVar}}: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
  \item \strong{\code{V}}: Named list of deterministic utilities . Utilities of the alternatives. Names of elements must match those in \code{alternatives.}
  \item \strong{\code{rows}}: Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
  \item \strong{\code{componentName}}: Character. Name given to model component.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item "estimate": Used for model estimation.
  \item "prediction": Used for model predictions.
  \item "validate": Used for validating input.
  \item "zero_LL": Used for calculating null likelihood.
  \item "conditionals": Used for calculating conditionals.
  \item "output": Used for preparing output after model estimation.
  \item "raw": Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \strong{\code{"prediction"}}: List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the probability of the chosen alternative.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}, but it also runs a set of tests to validate the function inputs.
          \item \strong{\code{"zero_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"raw"}}: Same as \code{"prediction"}
        }
}
\description{
Calculates probabilities of a multinomial logit model.
}
\examples{
### Load data
data(apollo_modeChoiceData)
database <- apollo_modeChoiceData
rm(apollo_modeChoiceData)

### Parameters
b = list(asc_1=0, asc_2=0, asc_3=0, asc_4=0, tt=0, tc=0, acc=0)

### List of utilities
V = list()
V[['car' ]] = b$asc_1 + b$tt*database$time_car  + b$tc*database$cost_car
V[['bus' ]] = b$asc_2 + b$tt*database$time_bus  + b$tc*database$cost_bus  +
              b$acc*database$access_bus
V[['air' ]] = b$asc_3 + b$tt*database$time_air  + b$tc*database$cost_air  +
              b$acc*database$access_air
V[['rail']] = b$asc_4 + b$tt*database$time_rail + b$tc*database$cost_rail +
              b$acc*database$access_rail

### MNL settings
mnl_settings <- list(
   alternatives = c(car=1, bus=2, air=3, rail=4),
   avail        = list(car=database$av_car, bus=database$av_bus,
                       air=database$av_air, rail=database$av_rail),
   choiceVar    = database$choice,
   V            = V
)

### Compute choice probabilities using MNL model
apollo_mnl(mnl_settings, functionality="estimate")
}
