% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_makeLogLike.R
\name{apollo_makeLogLike}
\alias{apollo_makeLogLike}
\title{Creates log-likelihood function.}
\usage{
apollo_makeLogLike(
  apollo_beta,
  apollo_fixed,
  apollo_probabilities,
  apollo_inputs,
  apollo_estSet,
  cl = NA
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{apollo_estSet}{List of estimation options. It must contain at least one element called
estimationRoutine defining the estimation algorithm. See \link{apollo_estimate}.}

\item{cl}{Cluster as provided by \link[parallel]{makeCluster}. Assumed to be PSock.}
}
\value{
apollo_logLike function.
}
\description{
Creates log-likelihood function from the likelihood function apollo_probabilities provided by the user.
}
\details{
Internal use only. Called by \code{apollo_estimate} before estimation.
The returned function can be single-threaded or multi-threaded based on the model options.
}
