% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_apa.R
\name{cor_apa}
\alias{cor_apa}
\title{Report Correlation in APA style}
\usage{
cor_apa(x, format = c("text", "markdown", "rmarkdown", "html", "latex",
  "docx", "plotmath"), info = FALSE, print = TRUE)
}
\arguments{
\item{x}{A call to \code{cor.test}}

\item{format}{Character string specifying the output format. One of
\code{"text"}, \code{"markdown"}, \code{"rmarkdown"}, \code{html},
\code{"latex"}, \code{"docx"} or \code{"plotmath"}.}

\item{info}{Logical indicating whether to print a message on the used test
(default is \code{FALSE})}

\item{print}{Logical indicating wheter to print the formatted output via
\code{cat} (\code{TRUE}, default) or return as character string.}
}
\description{
Report Correlation in APA style
}
\examples{
# Example data from ?cor.test
x <- c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1)
y <- c( 2.6,  3.1,  2.5,  5.0,  3.6,  4.0,  5.2,  2.8,  3.8)

cor_apa(cor.test(x, y))

# Spearman's rho
cor_apa(cor.test(x, y, method = "spearman"))

# Kendall's tau
cor_apa(cor.test(x, y, method = "kendall"))

}

