#' Generate a Data Package from `anyflights` Data
#' 
#' Generate a data-only package, including documentation, from data outputted
#' by the `anyflights()` function. Please do not submit the outputted package to
#' CRAN or similar repositories as original packages.
#' 
#' @param data A named list of dataframes outputted by 
#'   \code{\link{anyflights}}.
#' 
#' @param name The desired name of the resulting package as a character string.
#' The package will check that the supplied package name is valid using the
#' regular expression \code{.standard_regexps()$valid_package_name}, and save
#' the output in a directory by the same name. Defaults to 
#' \code{make.names(deparse(substitute(data)))}.
#' 
#' @return A directory containing a data-only package built around the
#' supplied data.
#' 
#' @export
as_flights_package <- function(data, name = make.names(deparse(substitute(data)))) {
  
  check_as_flights_package_arguments(data, name)
  
  usethis::create_package(
    path = name,
    open = FALSE,
    field = list(
      `Authors@R` = 'c(
      person("Simon P.", "Couch", , "simonpatrickcouch@gmail.com", c("aut", "cre")),
      person("Hadley", "Wickham", , "hadley@rstudio.com", "aut"),
      person("RStudio", role = "cph"),
      person("Jay", "Lee", , "jaylee@reed.edu", "ctb"),
      person("Dennis", "Irorere", , "denironyx@gmail.com", "ctb")
      )',
      `Package` = name,
      `Depends` = "R (>= 3.5.0)",
      `Title` = "Flights and Other Useful Metadata",
      `Description` = "A data-only package generated by anyflights supplying
                       data on flights as well as other useful metadata.",
      `LazyData` = "true",
      `License` = "CC0",
      `URL` = "http://github.com/simonpcouch/anyflights",
      `BugReports` = "https://github.com/simonpcouch/anyflights/issues",
      `Suggests` = "anyflights")
  )
  
  save_flights_data(data, name)
  
  write_flights_documentation(name)
  
  invisible(TRUE)
  
}
