% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeWaterValues.R
\name{writeWaterValues}
\alias{writeWaterValues}
\title{Write water values}
\usage{
writeWaterValues(area, data = NULL, overwrite = TRUE,
  opts = antaresRead::simOptions())
}
\arguments{
\item{area}{The area where to add the water values.}

\item{data}{A 365*101 numeric matrix: table of marginal values for the stored energy, which depends
on the date (365 days) and on the reservoir level (101 round percentage values ranging from
0% to 100%). OR a 3-column matrix with 365*101 rows. In this latter case the 3 columns must
be 'date', 'level' and 'value' (in this order), and the rows must be sorted by:
ascending day, ascending level.}

\item{overwrite}{Logical. Overwrite the values if a file already exists.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}.}
}
\description{
Write water values
}
\examples{
\dontrun{

writeWaterValues("fictive_area", data = matrix(rep(0, 365*101), nrow = 365))

}
}
