% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifySequence.R
\name{classifySequence}
\alias{classifySequence}
\title{Leverage sequences to classify images}
\usage{
classifySequence(
  imagesallanimal,
  mlpredictions,
  classes,
  emptycol,
  maxdiff = 60
)
}
\arguments{
\item{imagesallanimal}{subselection of all images that contain MD animals}

\item{mlpredictions}{classifier predictions}

\item{classes}{list of all possible classes}

\item{emptycol}{integer that represents the empty class}

\item{maxdiff}{maximum difference between images in seconds to be included in a sequence, defaults to 60}
}
\value{
reclassified imagesallanimal dataframe
}
\description{
Images must be within maxdiff seconds of each other to be considered in sequence.
This function retains "Empty" classification even if other images within the
sequence are predicted to contain animals.
Classification confidence is weighted by MD confidence.
}
\examples{
\dontrun{
predictions <-classifyCropsSpecies(images,modelfile,resize=456)
imagesallanimal <- classifySequences(images,predictions,classes,17,maxdiff=60)
}
}
