% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-quantile.r, R/stat-quantile.r
\name{geom_quantile}
\alias{geom_quantile}
\alias{stat_quantile}
\title{Add quantile lines from a quantile regression.}
\usage{
geom_quantile(mapping = NULL, data = NULL, stat = "quantile",
  position = "identity", ..., lineend = "butt", linejoin = "round",
  linemitre = 1, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)

stat_quantile(mapping = NULL, data = NULL, geom = "quantile",
  position = "identity", ..., quantiles = c(0.25, 0.5, 0.75),
  formula = NULL, method = "rq", method.args = list(),
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_quantile} and \code{stat_quantile}.}

\item{quantiles}{conditional quantiles of y to calculate and display}

\item{formula}{formula relating y variables to x variables}

\item{method}{Quantile regression method to use.  Currently only supports
\code{\link[quantreg]{rq}}.}

\item{method.args}{List of additional arguments passed on to the modelling
function defined by \code{method}.}
}
\description{
This can be used as a continuous analogue of a geom_boxplot.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{animint2:::rd_aesthetics("geom", "quantile")}
}

\section{Computed variables}{

\describe{
  \item{quantile}{quantile of distribution}
}
}

\examples{
m <- ggplot(mpg, aes(displ, 1 / hwy)) + geom_point()
m + geom_quantile()
m + geom_quantile(quantiles = 0.5)
q10 <- seq(0.05, 0.95, by = 0.05)
m + geom_quantile(quantiles = q10)

# You can also use rqss to fit smooth quantiles
m + geom_quantile(method = "rqss")
# Note that rqss doesn't pick a smoothing constant automatically, so
# you'll need to tweak lambda yourself
m + geom_quantile(method = "rqss", lambda = 0.1)

# Set aesthetics to fixed value
m + geom_quantile(colour = "red", size = 2, alpha = 0.5)
}
