% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrho_fc.R
\name{rrho_fc}
\alias{rrho_fc}
\title{Griddy Gibbs update for dyadic correlation}
\usage{
rrho_fc(Z, Sab, s2 = 1, offset = 0, ngp = 100, asp = NULL)
}
\arguments{
\item{Z}{n X n normal relational matrix}

\item{Sab}{covariance of additive effects}

\item{s2}{residual variance}

\item{offset}{matrix of the same dimension as Z. It is assumed that 
Z-offset follows an SRM distribution, so the offset should contain any 
regression terms and multiplicative effects (such as 
\code{Xbeta(X,beta+ U\%*\%t(V) }   )}

\item{ngp}{the number of points for an unevenly-spaced 
grid on which to approximate the full conditional distribution}

\item{asp}{use arc sine prior (TRUE) or uniform prior (FALSE)}
}
\value{
a value of rho
}
\description{
Simulation of dyadic correlation from its approximate full conditional 
distribution using griddy Gibbs sampling
}
\author{
Peter Hoff
}
