% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise-white.R
\name{noise_white}
\alias{noise_white}
\alias{gen_white}
\title{White noise generator}
\usage{
noise_white(
  dim,
  frequency = 0.01,
  pertubation = "none",
  pertubation_amplitude = 1
)

gen_white(x, y = NULL, z = NULL, t = NULL, frequency = 1, seed = NULL, ...)
}
\arguments{
\item{dim}{The dimensions (height, width, (and depth, (and time))) of the
noise to be generated. The length determines the dimensionality of the noise.}

\item{frequency}{Determines the granularity of the features in the noise.}

\item{pertubation}{The pertubation to use. Either \code{'none'} (default),
\code{'normal'}, or \code{'fractal'}. Defines the displacement (warping) of the noise,
with \code{'normal'} giving a smooth warping and \code{'fractal'} giving a more eratic
warping.}

\item{pertubation_amplitude}{The maximal pertubation distance from the
origin. Ignored if \code{pertubation = 'none'}. Defaults to \code{1}.}

\item{x, y, z, t}{Coordinates to get noise value from}

\item{seed}{The seed to use for the noise. If \code{NULL} a random seed will be
used}

\item{...}{ignored}
}
\value{
For \code{noise_white()} a matrix if \code{length(dim) == 2} or an array if
\code{length(dim) >= 3}. For \code{gen_white()} a numeric vector matching the length of
the input.
}
\description{
White noise is a random noise with equal intensities at different
frequencies. It is most well-known as what appeared on old televisions when
no signal was found.
}
\examples{
# Basic use
noise <- noise_white(c(100, 100))

plot(as.raster(normalise(noise)))

# Using the generator
grid <- long_grid(seq(1, 10, length.out = 1000), seq(1, 10, length.out = 1000))
grid$noise <- gen_white(grid$x, grid$y)
plot(grid, noise)

}
