% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNc.R
\name{plotNc}
\alias{plotNc}
\title{Plots the time-mean of a variable stored in NetCDF model output on a regular grid}
\usage{
plotNc(long.name, nc.mod, mod.id, unit.conv.mod, variable.unit, timePeriod,
  outlier.factor = 1000, my.xlim = c(-180, 180), my.ylim = c(-60,
  85), plot.width = 8, plot.height = 3.8, outputDir = FALSE)
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{nc.mod}{A string that gives the path and name of the netcdf file that contains the model output, e.g. '/home/model_gpp.nc'}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CLASSIC'}

\item{unit.conv.mod}{A number that is used as a factor to convert the unit of the model data, e.g. 86400}

\item{variable.unit}{A string that gives the final units using LaTeX notation, e.g. 'gC m$^{-2}$ day$^{-1}$'}

\item{timePeriod}{A string that gies the time period over which to average the data, e.g. c('1980-01', '2017-12')}

\item{outlier.factor}{A number that is used to define outliers, e.g. 10.
Plotting raster objects that contain extreme outliers lead to figures where
most grid cells are presented by a single color since the color legend covers
the entire range of values. To avoid this, the user may define outliers that
will be masked out and marked with a red dot. Outliers are all values that
exceed the interquartile range multiplied by the outlier factor defined here.}

\item{my.xlim}{An R object that gives the longitude range that you wish to plot, e.g. c(-180, 180)}

\item{my.ylim}{An R object that gives the longitude range that you wish to plot, e.g. c(-90, 90)}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory}
}
\value{
Figures in PDF format that show the time-mean, spatial-mean, zonal mean, and seasonal cycle.
}
\description{
This function plots the time-mean, spatial-mean, zonal mean, and
seasonal cycle of variable stored in NetCDF model output. The function expects
model data to be on a regular grid.
}
\examples{

library(amber)
library(ncdf4)
library(raster)

long.name <- 'Gross primary productivity'
nc.mod <- system.file('extdata/modelRegular', 'gpp_monthly.nc', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
unit.conv.mod <- 86400*1000 # optional unit conversion for model data
variable.unit <- 'gC m$^{-2}$ day$^{-1}$' # unit after conversion (LaTeX notation)
timePeriod <- c('1980-01', '2017-12')
outlier.factor <- 1

plotNc(long.name, nc.mod, mod.id, unit.conv.mod, variable.unit, timePeriod, outlier.factor)

}
