% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLocation.R
\name{getLocation}
\alias{getLocation}
\title{Get location from coordinate}
\usage{
getLocation(
  lng,
  lat,
  key = NULL,
  poitype = NULL,
  radius = NULL,
  extensions = NULL,
  roadlevel = NULL,
  sig = NULL,
  output = NULL,
  callback = NULL,
  homeorcorp = 0,
  to_table = TRUE,
  keep_bad_request = TRUE,
  max_core = NULL
)
}
\arguments{
\item{lng}{Required. \cr
Longitude in decimal}

\item{lat}{Required. \cr
Latitude in decimal}

\item{key}{Optional.\cr
Amap Key. \cr
Applied from 'AutoNavi' Map API official website\url{https://lbs.amap.com/dev/}}

\item{poitype}{Optional.\cr
Return nearby POI types.\cr
When `extensions = all`, this argument makes sense. For detailed poitype type, please refer\url{https://lbs.amap.com/api/webservice/download}}

\item{radius}{Optional.\cr
Searching radius.\cr
radius ranges from 0 to 3000, the default value is 1000, unit: meter.}

\item{extensions}{Optional.\cr
Return results controller.\cr
`base`: the default value, it only return base information about coordinate.\cr
`all`: it will return nearby POI, road information and cross information.}

\item{roadlevel}{Optional.\cr
Road levels.\cr
When `extensions = all`, this argument makes sense. \cr
`roadlevel=0`, return all roads.\cr
`roadlevel=1`, only return main roads.}

\item{sig}{Optional.\cr
Digital Signature.\cr
How to use this argument? Please check here{https://lbs.amap.com/faq/account/key/72}}

\item{output}{Optional.\cr
Output Data Structure. \cr
Support JSON and XML. The default value is JSON.}

\item{callback}{Optional.\cr
Callback Function. \cr
The value of callback is the customized function. Only available with JSON output.
If you don't understand, it means you don't need it, just like me.}

\item{homeorcorp}{Optional.\cr
Optimize the order of returned POI or not.\cr
When `extensions = all`, this argument makes sense. \cr
`homeorcorp=0`, do not optimize, by default.\cr
`homeorcorp=1`, home related POIs are first, by default.\cr
`homeorcorp=2`, corporation related POIs are first, by default.\cr}

\item{to_table}{Optional.\cr
Transform response content to a table.}

\item{keep_bad_request}{Optional.\cr
Keep Bad Request to avoid breaking a workflow, especially meaningful in a batch request}

\item{max_core}{Optional.\cr
A threshold of max cores for parallel operation. There is no need to set a `max_core` generally.
But for some extreme high performance case, like `AMD Threadripper` and `Intel Xeon`,
super multiple-core CPU will meet the limitation of queries per second.}
}
\value{
Returns a JSON, XML or data.table of results containing detailed reverse geocode information. See \url{https://lbs.amap.com/api/webservice/guide/api/georegeo} for more information.
}
\description{
Get location from coordinate
}
\examples{
\dontrun{
library(amapGeocode)

# Before the `getLocation()` is executed,
# the token should be set by `option(amap_key = 'key')`
# or set by key argument in `getLocation()`

# Get reverse-geocode as a table
getLocation(104.043284, 30.666864)
# Get reverse-geocode as a XML
getLocation('104.043284, 30.666864', output = 'XML')

}

}
\seealso{
\code{\link{extractCoord}}
}
