% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_huc}
\alias{process_huc}
\title{Retrieve Hydrologic Unit Code (HUC) data}
\usage{
process_huc(
  path,
  layer_name = NULL,
  huc_level = NULL,
  huc_header = NULL,
  extent = NULL,
  ...
)
}
\arguments{
\item{path}{character. Path to the file or the directory containing HUC data.}

\item{layer_name}{character(1). Layer name in the \code{path}}

\item{huc_level}{character(1). Field name of HUC level}

\item{huc_header}{character(1). The upper level HUC code header to extract
lower level HUCs.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Arguments passed to \code{nhdplusTools::get_huc()}}
}
\value{
a \code{SpatVector} object
}
\description{
Retrieve Hydrologic Unit Code (HUC) data
}
\examples{
## NOTE: Examples are wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
library(terra)
getf <- "WBD_National_GDB.gdb"
# check the layer name to read
terra::vector_layers(getf)
test1 <- process_huc(
  getf,
  layer_name = "WBDHU8",
  huc_level = "huc8"
)
test2 <- process_huc(
  getf,
  layer_name = "WBDHU8",
  huc_level = "huc8"
)
test3 <- process_huc(
  "",
  layer_name = NULL,
  huc_level = NULL,
  huc_header = NULL,
  id = "030202",
  type = "huc06"
)
}
}
\seealso{
\code{\link[nhdplusTools:get_huc]{nhdplusTools::get_huc}}
}
\author{
Insang Song
}
