% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aou_ls.R
\name{aou_ls_workspace}
\alias{aou_ls_workspace}
\title{List the current files in your workspace}
\usage{
aou_ls_workspace(pattern = "", silent = FALSE, ...)
}
\arguments{
\item{pattern}{Regular expression, such as "*.csv" or a single file name
e.g., "mydata.csv". Default will find all files apart from notebooks
(.ipynb, .Rmd, .qmd files).}

\item{silent}{Whether to omit the names of files found. Defaults to \code{FALSE}.}

\item{...}{Other arguments passed to \code{list.files()}}
}
\value{
A vector of file names
}
\description{
Lists all data files in the workspace or files matching a
certain pattern.
}
\examples{
my_workspace_files <- aou_ls_workspace(silent = TRUE)
aou_ls_workspace("*.csv")
aou_ls_workspace(path = "data")

}
