test_that("Half-Width at Half-Maximum", {
  w <- c(0.504, 0.317, 1.614, 0.565, 6, 0.416, 7, 0.34, 0.747, 12, 0.163,
         0.319, 0.822, 6, 0.94, 0.877, 0.875, 0.857, 2.026, 3, 0.897,
         1.198, 1.692, 0.699, 0.539, 1.338, 0.822, 1.841, 0.097, 0.987,
         0.161, 0.641, 1.657, 0.479, 0.758, 0.007, 0.261, 11, 0.262, 1.095,
         0.294, 2.007, 1.34, 0.517, 0.89, 0.228, 1.333, 0.462, 1.508,
         0.249, 4, 0.365, 0.301, 0.852, 1.129, 0.978, 1.744, 1.421, 1.07,
         1.462, 0.48, 1.453, 0.083, 6, 0.914, 0.361, 0.896, 0.553, 1.648,
         0.018, 0.296, 0.748, 0.28, 1.353, 13, 14, 0.749, 0.746, 0.377,
         0.341, 0.043, 0.488, 0.793, 1.322, 0.579, 0.162, 1.003, 0.427,
         0.212, 1.124, 1.047, 0.089, 0.305, 0.896, 0.513, 0.338, 0.087,
         0.067, 2.997, 1.954)

  peaks <- peaks_find(seq_along(w), w, SNR = 3, m = 1)
  expect_snapshot(peaks)

  # plot(w, type = "l")
  # lines(peaks, type = "p", pch = 16, col = "red")
})
test_that("Half-Width at Half-Maximum", {
  x <- seq(-4, 4, length = 10000)
  y <- dnorm(x)

  # Expected: 2 * sqrt(2 * log(2))
  expect_equal(round(peaks_fwhm(x, y, center = 0), 3), 2.355)
})
