% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/smooth.R
\docType{methods}
\name{smooth_whittaker}
\alias{smooth_whittaker}
\alias{smooth_whittaker-method}
\alias{smooth_whittaker,numeric,numeric-method}
\alias{smooth_whittaker,ANY,missing-method}
\title{Whittaker Smoothing}
\usage{
smooth_whittaker(x, y, ...)

\S4method{smooth_whittaker}{numeric,numeric}(x, y, lambda = 1600, d = 2, sparse = FALSE)

\S4method{smooth_whittaker}{ANY,missing}(x, lambda = 1600, d = 2, sparse = FALSE)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{lambda}{An \code{\link{integer}} giving the smoothing parameter. The larger
\code{lambda} is, the smoother the curve.}

\item{d}{An \code{\link{integer}} specifying the order of the penalty.}

\item{sparse}{A \code{\link{logical}} scalar: should sparse matrices be used for
computation? If \code{TRUE}, \pkg{Matrix} is required.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Whittaker Smoothing
}
\examples{
## Simulate data with some noise
x <- seq(-4, 4, length = 100)
y <- dnorm(x) + rnorm(100, mean = 0, sd = 0.01)

## Plot spectrum
plot(x, y, type = "l", xlab = "", ylab = "")

## Rectangular smoothing
unweighted <- smooth_rectangular(x, y, m = 3)
plot(unweighted, type = "l", xlab = "", ylab = "")

## Triangular smoothing
weighted <- smooth_triangular(x, y, m = 5)
plot(weighted, type = "l", xlab = "", ylab = "")

## Loess smoothing
loess <- smooth_loess(x, y, span = 0.75)
plot(loess, type = "l", xlab = "", ylab = "")

## Savitzky–Golay filter
savitzky <- smooth_savitzky(x, y, m = 21, p = 2)
plot(savitzky, type = "l", xlab = "", ylab = "")

## Whittaker smoothing
whittaker <- smooth_whittaker(x, y, lambda = 1600, d = 2)
plot(whittaker, type = "l", xlab = "", ylab = "")
}
\references{
Eilers, P. H. C. (2003). A Perfect Smoother. \emph{Analytical Chemistry},
75(14): 3631-36. \doi{10.1021/ac034173t}.
}
\seealso{
Other smoothing methods: 
\code{\link{smooth_loess}()},
\code{\link{smooth_rectangular}()},
\code{\link{smooth_savitzky}()},
\code{\link{smooth_triangular}()}
}
\author{
N. Frerebeau
}
\concept{smoothing methods}
