% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algaebase_search_df.r
\name{algaebase_search_df}
\alias{algaebase_search_df}
\title{Search algaebase for information about a list of phytoplankton names}
\usage{
algaebase_search_df(
  df,
  apikey = NULL,
  handle = NULL,
  genus.only = FALSE,
  genus.name = "genus",
  species.name = "species",
  higher = TRUE,
  print.full.json = FALSE,
  long = FALSE,
  exact.matches.only = TRUE,
  api_file = NULL,
  sleep.time = 1
)
}
\arguments{
\item{df}{data frame containing columns with genus and species names}

\item{apikey}{valid key for algaebase API as character string}

\item{handle}{curl handle with API key. Will be created if not present.}

\item{genus.only}{boolean: should searches be based solely on the genus name?}

\item{genus.name}{name of data.frame column that contains genus names}

\item{species.name}{name of data.frame column that contains species names}

\item{higher}{boolean should higher taxonomy be included in output?}

\item{print.full.json}{boolean returns raw json output if TRUE. Default is FALSE (return R data frame)}

\item{long}{boolean return long output including full species name and authorship, and entry date from algaebase.}

\item{exact.matches.only}{boolean should results be limited to exact matches?}

\item{api_file}{path to text file containing a valid API key}

\item{sleep.time}{delay between algaebase queries (in seconds). Should be at least 1 second if querying more than 10 names at once.}
}
\value{
data frame that may include: accepted.name (currently accepted synonym if different from input name), input.name (name supplied by user), input.match (1 if exact match, else 0), currently.accepted (1=TRUE/0=FALSE), genus.only (1=genus search/0=genus+species search),higher taxonomy (kingdom,phylum,class,order,family), genus, species (always NA for genus search), infraspecies name (always NA for genus search), long.name (includes author and date if given), taxonomic.status (currently accepted, synonym, or unverified), taxon.rank (taxonomic rank of accepted name (genus, species, infraspecies), mod.date (date when entry was last modified in algaebase).
}
\description{
Search algaebase for information about a list of phytoplankton names
}
\examples{
\dontrun{
data(lakegeneva)
#example dataset with 50 rows

new.lakegeneva <- genus_species_extract(lakegeneva,'phyto_name')
lakegeneva.algaebase<-algaebase_search_df(new.lakegeneva[1:10,],higher=TRUE,long=TRUE)
head(lakegeneva.algaebase)}

}
