% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmKDEboot.R
\name{mmKDEboot}
\alias{mmKDEboot}
\alias{mmKDEboot.default}
\alias{print.mmKDEboot}
\alias{summary.mmKDEboot}
\alias{print.summary.mmKDEboot}
\alias{mmKDEboot.formula}
\alias{predict.mmKDEboot}
\title{Moment matching for kernel density estimators.}
\usage{
mmKDEboot(formula, data = list(), xin, type, bootstraps, bootName, ...)

\method{mmKDEboot}{default}(formula, data = list(), xin, type, bootstraps,
  bootName, ...)

\method{print}{mmKDEboot}(x, ...)

\method{summary}{mmKDEboot}(object, ...)

\method{print}{summary.mmKDEboot}(x, ...)

\method{mmKDEboot}{formula}(formula, data = list(), xin, type, bootstraps,
  bootName, ...)

\method{predict}{mmKDEboot}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{xin}{Numeric vector of length equal to the number of independent variables, of initial values, for the parameters to be estimated.}

\item{type}{An integer specifying the bandwidth selection method used, see \code{\link{bw}}.}

\item{bootstraps}{An integer giving the number of bootstrap samples.}

\item{bootName}{The name of the .rds file to store the mmKDEboot object.  May include a path.}

\item{...}{Arguments to be passed on to the control argument of the \code{\link{optim}} function.}

\item{x}{An mmKDEboot object.}

\item{object}{An mmKDEboot object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class mmKDEboot.

mmKDEboot.default: A list object (saved using \code{saveRDS} in the specified location) with the following components:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item coefDist The bootstrap parameter distribution.
\item bcoefficients: A vector of bootstrap coefficients, resulting from bootstrap estimation.
\item df: Degrees of freedom of the model.
\item se: The standard errors for the estimates resulting from bootstrap estimation.
\item error: The value of the objective function.
\item errorList: A vector of values of the objective function for each bootstrap sample.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
\item h_y: The KDE bandwidth estimator for the dependent variable.
\item h_X: The KDE bandwidth estimator for the independent variables, i.e. \eqn{\mathbf{X}\underline{\hat{\beta}}}.
\item MOMy: The first \eqn{n} non central moments of the dependent variable, where \eqn{n} is the number of columns in the design matrix.
\item MOMX: The first \eqn{n} non central moments of the independent variables \eqn{\mathbf{X}\underline{\hat{\beta}}}, where \eqn{n} is the number of columns in the design matrix.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
}

summary.mmKDEboot: A list of class summary.mmKDEboot with the following components:
\itemize{
\item call: Original call to \code{mmKDEboot} function.
\item coefficients: A matrix with estimates, estimated errors, and 95\% parameter confidence intervals (based on the inverse empirical distribution function).
\item moments: A matrix of the first \eqn{n} moments of the dependent and independent variables that were matched.  The final row corresponds to the estimated bandwidth parameters for each, i.e. \code{h_y} and \code{h_X}, respectively.
\item r.squared: The \eqn{r^{2}} coefficient.
\item adj.r.squared: The adjusted \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item df: Degrees of freedom for the model.
\item error: Value of the objective function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
\item residSum: Summary statistics for the distribution of the residuals.
\item errorSum: Summary statistics for the distribution of the value of the objective function.
}

print.summary.mmKDEboot: The object passed to the function is returned invisibly.

predict.mmKDEboot: A vector of predicted values resulting from the estimated model.
}
\description{
Bootstrap estimates, along with standard  errors and confidence intervals, of a linear model, resulting from moment matching of kernel density estimates.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for mmKDEboot.

\item \code{mmKDEboot}: print method for mmKDEboot.

\item \code{mmKDEboot}: summary method for mmKDEboot.

\item \code{summary.mmKDEboot}: print method for summary.mmKDEboot.

\item \code{formula}: formula method for mmKDEboot.

\item \code{mmKDEboot}: predict method for mmKDEboot.
}}

